	function [Zodd, Podd, Zeven, Peven] = SORT_LATTICE_POLES_LP_S(P)
	
	% 	Determines the reflectances S1 (odd) and S2 (even) in an analog lattice filter
	%	in terms of the poles and zeros of the corresponding allpas functions.
	%	The order must be odd for lowpass and highpass filters.
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB 	
	
	% 	Author: 		Lars Wanhammar 2009-08-09
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	if mod(length(P), 2) ~= 1
		error('The order must be odd for lowpass and highpass filters')  
	end
	% Sort the poles into odd- and even-order branches
	N = length(P);
	P = cplxpair(P);
	Podd = P(N);
	Peven = [];
	m = 1;
	for k = 1:2:N-1	
		if mod(m,2) == 1
			Peven = [P(k); Peven];
			Peven = [P(k+1); Peven];
		else
			Podd = [P(k); Podd];
			Podd = [P(k+1); Podd];
		end
		m = m+1;
	end
	Podd = cplxpair(Podd);
	Zodd = -Podd;
	Peven = cplxpair(Peven);
	Zeven = -Peven;	
	
